function all_paths = f1_generate_paths(root_path)
%% This function generates a proper folder structure and returns all paths 
% as a structure. If folders already exist, it returns all paths without
% creating new folders.


disp(' ')
disp(['Checking directories...'])


all_paths                   = [];
% all_paths.folder_name       = '';
% all_paths.folder_abs_path   = root_path;
% all_paths.shapes_source     = '';


% Find the folder name:
z           = regexp(root_path, filesep, 'split');
folder_name   = z{end};
% if there was a trailing filesep, then cell name will be empty:
if isempty(z{end})
    folder_name = z{end-1};
end
all_paths.folder_name    = folder_name;



% Paths to generate
new_dir_list_vals       = {[root_path, filesep], [root_path, filesep, 'shape_source', filesep]};
new_dir_list_keys       = {'folder_abs_path', 'shapes_source'};

for i = 1 : length(new_dir_list_vals)
    current_path = [new_dir_list_vals{i}];
    if ~exist(current_path, 'dir')
        success = mkdir(current_path);
        if success
            disp(['    Created: ' current_path])
            all_paths.(new_dir_list_keys{i}) = current_path;
        else
            disp(['    Failed: ' current_path])
        end
    else
        disp(['    Exists: ' current_path])
        all_paths.(new_dir_list_keys{i}) = current_path;
    end
end



%% Check if the labeled bodies exist.
% try to load the labeled bodies data (if it exists). 
file_name           = 'labeled_bodies.mat';
file_path           = [all_paths.shapes_source, file_name];

if ~exist(file_path, 'file')    
    disp(' ')
    disp(['    Labeled Bodies are not found:']);
    disp(['    ', file_path]);
    disp(['    You will need to generate this file.']);
else
    disp(' ')
    disp(['Found Labeled bodies in: ']);
    disp(['    ', file_path]);
end


